/******************************************************************************
* (C) Copyright 2007 by Agilent Technologies, All Rights Reserved.
******************************************************************************/

#ifndef AGTPCIEEXERCISER_H
#define AGTPCIEEXERCISER_H

#include "AgtPCIPort.h"
#include "devpciedefs.h"

class CAgtPCIEControl;
class CPCIEMemoryMgmt;
class CPCIEFpgaFramework;
class CPCIESiMgmt;

// Provides access to all Exerciser functions.
// In order to get the port handle needed for all exerciser functions,
// create an instance of CAgtPortSelector and call its Connect() function before.
class AGTPCIPORT_API CAgtPCIEExerciser
{
    /*
      - Provides access to (i.e. contains) all exerciser API functions needed for communicating with IO module.
      - All these API functions:
        1. Get a port handle as its first parameter.
          (To get this port handle a connection must first be established via the 
            functions of class CAgtPortSelector). 
        2. Return values are always passed per pointer.
        3. Are completely based on protected RegRead/Write functions
        4. Return void
      - Visible to customer
      - OS independent
      - Must be instantiated (no static functions) on heap or stack
      - Contains protected RegRead/Write functions which are called by all exerciser 
        API functions. RegRead/Write call the RegRead/Write functions of class
        CAgtPCIEControl.
      - Creates and holds instance of class CAgtPCIEControl.
        All functions of this class are directly mapped to class CAgtPCIEControl.
    */

    public:
        // Constructor
        CAgtPCIEExerciser(void);
        ~CAgtPCIEExerciser(void);

        // API functions //////////////////////////////////////////////////////
        
        void BlockDefaultSet( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIEHwChannelFunction channel,
            /* [in] */ AgtSizeT line);
        
        void BlockGenDefaultSet( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIEHwChannelFunction channel);
        
        void BlockGenGet( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIEHwChannelFunction channel,
            /* [in] */ EPCIEBlockGen prop,
            /* [retval][out] */ AgtValueT *val);
        
        void BlockGenSet( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIEHwChannelFunction channel,
            /* [in] */ EPCIEBlockGen prop,
            /* [in] */ AgtValueT val);
        
        void BlockGet( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIEHwChannelFunction channel,
            /* [in] */ AgtSizeT line,
            /* [in] */ EPCIEBlock prop,
            /* [retval][out] */ AgtValueT *val);
        
        void BlockSet( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIEHwChannelFunction channel,
            /* [in] */ AgtSizeT line,
            /* [in] */ EPCIEBlock prop,
            /* [in] */ AgtValueT val);
        
        void CompBehDefaultSet( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIECompQueue queue,
            /* [in] */ AgtSizeT line);
        
        void CompBehGenDefaultSet( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIECompQueue queue);
        
        void CompBehGenGet( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIECompQueue queue,
            /* [in] */ EPCIECompBehGen prop,
            /* [retval][out] */ AgtValueT *val);
        
        void CompBehGenSet( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIECompQueue queue,
            /* [in] */ EPCIECompBehGen prop,
            /* [in] */ AgtValueT val);
        
        void CompBehGet( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIECompQueue queue,
            /* [in] */ AgtSizeT line,
            /* [in] */ EPCIECompBeh prop,
            /* [retval][out] */ AgtValueT *val);
        
        void CompBehSet( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIECompQueue queue,
            /* [in] */ AgtSizeT line,
            /* [in] */ EPCIECompBeh prop,
            /* [in] */ AgtValueT val);
        
        void ReqBehDefaultSet( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIEHwChannelFunction channel,
            /* [in] */ AgtSizeT line);
        
        void ReqBehGenDefaultSet( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIEHwChannelFunction channel);
        
        void ReqBehGenGet( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIEHwChannelFunction channel,
            /* [in] */ EPCIEReqBehGen prop,
            /* [retval][out] */ AgtValueT *val);
        
        void ReqBehGenSet( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIEHwChannelFunction channel,
            /* [in] */ EPCIEReqBehGen prop,
            /* [in] */ AgtValueT val);
        
        void ReqBehGet( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIEHwChannelFunction channel,
            /* [in] */ AgtSizeT line,
            /* [in] */ EPCIEReqBeh prop,
            /* [retval][out] */ AgtValueT *val);
        
        void ReqBehSet( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIEHwChannelFunction channel,
            /* [in] */ AgtSizeT line,
            /* [in] */ EPCIEReqBeh prop,
            /* [in] */ AgtValueT val);
        
        void ExerciserGet( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIEExerciser prop,
            /* [retval][out] */ AgtValueT *val);
        
        void ExerciserSet( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIEExerciser prop,
            /* [in] */ AgtValueT val);
        
        void Run( 
            /* [in] */ AgtPortHandleT portHandle);
        
        void Stop( 
            /* [in] */ AgtPortHandleT portHandle);
        
        void RunFunctions( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ AgtValueT functions);
        
        void StopFunctions( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ AgtValueT functions);
        
        void DataMemRead( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ AgtSizeT offset,
            /* [in] */ AgtSizeT length,
            /* [out][in] */ AgtSizeT *pCount,
            /* [out] */ UInt8 *psaData);
        
        void DataMemWrite( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ AgtSizeT offset,
            /* [in] */ AgtSizeT length,
            /* [out] */ UInt8 *psaData);
        
        void ConfRegMaskRead( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIEHwChannelFunction functionNum,
            /* [in] */ AgtSizeT offset,
            /* [retval][out] */ AgtValueT *val);
        
        void ConfRegMaskWrite( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIEHwChannelFunction functionNum,
            /* [in] */ AgtSizeT offset,
            /* [in] */ AgtValueT val);
        
        void ConfRegRead( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIEHwChannelFunction functionNum,
            /* [in] */ AgtSizeT offset,
            /* [retval][out] */ AgtValueT *val);
        
        void ConfRegWrite( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIEHwChannelFunction functionNum,
            /* [in] */ AgtSizeT offset,
            /* [in] */ AgtValueT val);
        
        void FTRegRead( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ AgtSizeT offset,
            /* [retval][out] */ AgtValueT *val);
        
        void FTRegWrite( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ AgtSizeT offset,
            /* [in] */ AgtValueT val);
        
        void ConfRegDirectWrite( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ AgtSizeT offset,
            /* [in] */ AgtValueT val);
        
        void ConfRegDirectRead( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ AgtSizeT offset,
            /* [retval][out] */ AgtValueT *val);
        
        void DecRead( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIEHwChannelFunction functionNum,
            /* [in] */ EPCIEDec dec,
            /* [in] */ EPCIEDecProp prop,
            /* [retval][out] */ AgtValueT *val);
        
        void DecWrite( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIEHwChannelFunction functionNum,
            /* [in] */ EPCIEDec dec,
            /* [in] */ EPCIEDecProp prop,
            /* [in] */ AgtValueT val);
        
        void SiCompGet( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIESi prop,
            /* [retval][out] */ AgtValueT *val);
        
        void SiCompMemDWGet( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ AgtSizeT dwNum,
            /* [retval][out] */ AgtValueT *val);
        
        void SiCompMemGet( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ AgtSizeT numBytes,
            /* [out][in] */ AgtSizeT *pCount,
            /* [out] */ UInt8 *psaData);
        
        void SiDefaultSet( 
            /* [in] */ AgtPortHandleT portHandle);
        
        void SiReqGet( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIESi prop,
            /* [retval][out] */ AgtValueT *val);
        
        void SiReqMemDWGet( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ AgtSizeT dwNum,
            /* [retval][out] */ AgtValueT *val);
        
        void SiReqMemGet( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ AgtSizeT numBytes,
            /* [out][in] */ AgtSizeT *pCount,
            /* [out] */ UInt8 *psaData);
        
        void SiReqMemDWSet( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ AgtSizeT dwNum,
            /* [in] */ AgtValueT val);
        
        void SiReqMemSet( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ AgtSizeT numBytes,
            /* [out] */ UInt8 *psaData);
        
        void SiReqSet( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIESi prop,
            /* [in] */ AgtValueT val);
        
        void SiSend( 
            /* [in] */ AgtPortHandleT portHandle);
        
        void SiStatusGet( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIESiStatus status,
            /* [retval][out] */ AgtValueT *val);
        
        void ConfigSpaceRead( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIEHwChannelFunction functionNum,
            /* [in] */ EPCIEConfigSpace prop,
            /* [retval][out] */ AgtValueT *val);
        
        void ConfigSpaceWrite( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIEHwChannelFunction functionNum,
            /* [in] */ EPCIEConfigSpace prop,
            /* [in] */ AgtValueT val);
        
        void DataLinkStateRead( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [retval][out] */ AgtValueT *val);
        
        void DllPhyGet( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIEDllPhy prop,
            /* [retval][out] */ AgtValueT *val);
        
        void DllPhySet( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIEDllPhy prop,
            /* [in] */ AgtValueT val);
        
        void VCResourceRead( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIEVCResourceId channel,
            /* [in] */ EPCIEVCResourceProp prop,
            /* [retval][out] */ AgtValueT *val);
        
        void VCResourceStatusRead( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIEVCResourceId channel,
            /* [in] */ EPCIEVCResourceStatusProp prop,
            /* [retval][out] */ AgtValueT *val);
        
        void VCResourceStatusArrayRead( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIEVCResourceId channel,
            /* [out][in] */ AgtSizeT *pCount,
            /* [out] */ UInt8 *psaData);
        
        void VCResourceStatusSnapshot( 
            /* [in] */ AgtPortHandleT portHandle);
        
        void VCResourceWrite( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIEVCResourceId channel,
            /* [in] */ EPCIEVCResourceProp prop,
            /* [in] */ AgtValueT val);
        
        void LaneSkewRead( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ AgtSizeT lane,
            /* [retval][out] */ AgtValueT *val);
        
        void LaneSkewWrite( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ AgtSizeT lane,
            /* [in] */ AgtValueT val);
        
        void LinkUp( 
            /* [in] */ AgtPortHandleT portHandle);
        
        void LinkStateDirect( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIELinkStateDirect state);
        
        void LinkWidthStatusRead( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [retval][out] */ AgtValueT *val);
        
        void ProtocolErrorStatusClear( 
            /* [in] */ AgtPortHandleT portHandle);
        
        void ProtocolErrorStatusDump( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [retval][out] */ char **errortext);
        
        void ProtocolErrorAccuRead( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIEProtRule rule,
            /* [retval][out] */ AgtValueT *val);
        
        void ProtocolErrorFirstRead( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIEProtRule rule,
            /* [retval][out] */ AgtValueT *val);
        
        void ProtocolErrorMaskSet( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIEProtRule rule,
            /* [in] */ AgtValueT mask);
        
        void ProtocolErrorMaskGet( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIEProtRule rule,
            /* [retval][out] */ AgtValueT *mask);
        
        void ProtocolErrorStringGet( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIEProtRule rule,
            /* [retval][out] */ char **errortext);
        
        void ProtocolErrorVCAccuRead( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIEVCResourceId channel,
            /* [in] */ EPCIEProtRuleVC rule,
            /* [retval][out] */ AgtValueT *val);
        
        void ProtocolErrorVCFirstRead( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIEVCResourceId channel,
            /* [in] */ EPCIEProtRuleVC rule,
            /* [retval][out] */ AgtValueT *val);
        
        void ProtocolErrorVCMaskSet( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIEVCResourceId channel,
            /* [in] */ EPCIEProtRuleVC rule,
            /* [in] */ AgtValueT mask);
        
        void ProtocolErrorVCMaskGet( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIEVCResourceId channel,
            /* [in] */ EPCIEProtRuleVC rule,
            /* [retval][out] */ AgtValueT *mask);
        
        void ProtocolErrorVCStringGet( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIEProtRuleVC rule,
            /* [retval][out] */ char **errortext);
        
        void ProtocolErrorFunctionAccuRead( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIEHwChannelFunction functionNum,
            /* [in] */ EPCIEProtRuleFunction rule,
            /* [retval][out] */ AgtValueT *val);
        
        void ProtocolErrorFunctionFirstRead( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIEHwChannelFunction functionNum,
            /* [in] */ EPCIEProtRuleFunction rule,
            /* [retval][out] */ AgtValueT *val);
        
        void ProtocolErrorFunctionMaskSet( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIEHwChannelFunction functionNum,
            /* [in] */ EPCIEProtRuleFunction rule,
            /* [in] */ AgtValueT mask);
        
        void ProtocolErrorFunctionMaskGet( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIEHwChannelFunction functionNum,
            /* [in] */ EPCIEProtRuleFunction rule,
            /* [retval][out] */ AgtValueT *mask);
        
        void ProtocolErrorFunctionStringGet( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIEProtRuleFunction rule,
            /* [retval][out] */ char **errortext);
        
        void RxErrorSet( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIERxError prop,
            /* [in] */ AgtValueT val);
        
        void RxErrorStart( 
            /* [in] */ AgtPortHandleT portHandle);
        
        void RxErrorStop( 
            /* [in] */ AgtPortHandleT portHandle);
        
        void RxErrorGet( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIERxError prop,
            /* [retval][out] */ AgtValueT *val);
        
        void RxErrorStatusGet( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIERxErrorStatus prop,
            /* [retval][out] */ AgtValueT *val);
        
        void VCWrite( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIEHwChannelFunction functionNum,
            /* [in] */ AgtSizeT vcNum,
            /* [in] */ EPCIEVC prop,
            /* [in] */ AgtValueT val);
        
        void VCRead( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIEHwChannelFunction functionNum,
            /* [in] */ AgtSizeT vcNum,
            /* [in] */ EPCIEVC prop,
            /* [retval][out] */ AgtValueT *val);
        
        void TxStatusRead( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [retval][out] */ AgtValueT *val);
        
        void RxStatusRead( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [retval][out] */ AgtValueT *val);
        
        void ExerciserStatusRead( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIEExerciserStatus status,
            /* [retval][out] */ AgtValueT *val);
        
        void ExerciserStatusReset( 
            /* [in] */ AgtPortHandleT portHandle);
        
        void ExerciserStatusSnapshot( 
            /* [in] */ AgtPortHandleT portHandle);
        
        void ExerciserStatusFunctionReset( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIEHwChannelFunction functionNum);
        
        void ExerciserStatusFunctionSnapshot( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIEHwChannelFunction functionNum);
        
        void ExerciserPhyStatusRead( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIEExerciserPhyStatus status,
            /* [in] */ AgtSizeT lane_number,
            /* [retval][out] */ AgtValueT *val);
        
        void ExerciserChannelFunctionGet( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIEHwChannelFunction functionNum,
            /* [in] */ EPCIEExerciserHwChannelStatus status,
            /* [retval][out] */ AgtValueT *val);
        
        void ExerciserChannelFunctionSet( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIEHwChannelFunction functionNum,
            /* [in] */ EPCIEExerciserHwChannelStatus status,
            /* [in] */ AgtValueT val);
        
        void PatternMaskWrite( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ AgtSizeT term,
            /* [in] */ EPCIEPattern prop,
            /* [in] */ AgtValueT val);
        
        void PatternMaskRead( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ AgtSizeT term,
            /* [in] */ EPCIEPattern prop,
            /* [retval][out] */ AgtValueT *val);
        
        void PatternValueWrite( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ AgtSizeT term,
            /* [in] */ EPCIEPattern prop,
            /* [in] */ AgtValueT val);
        
        void PatternValueRead( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ AgtSizeT term,
            /* [in] */ EPCIEPattern prop,
            /* [retval][out] */ AgtValueT *val);
        
        void PatternStatusRead( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ AgtSizeT term,
            /* [retval][out] */ AgtValueT *val);
        
        void PatternStatusReset( 
            /* [in] */ AgtPortHandleT portHandle);
        
        void PatternRun( 
            /* [in] */ AgtPortHandleT portHandle);
        
        void PatternStop( 
            /* [in] */ AgtPortHandleT portHandle);
        
        void PatternDefaultSet( 
            /* [in] */ AgtPortHandleT portHandle);
        
        void PerformanceCounterStatusRead( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIEPerformanceCounterStatus prop,
            /* [in] */ AgtSizeT hi,
            /* [retval][out] */ AgtValueT *val);
        
        void PerformanceCounterVCStatusRead( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIEVCResourceId channel,
            /* [in] */ EPCIEPerformanceCounterVCStatus prop,
            /* [in] */ AgtSizeT hi,
            /* [retval][out] */ AgtValueT *val);
        
        void PerformanceCounterFunctionStatusRead( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIEHwChannelFunction functionNum,
            /* [in] */ EPCIEPerformanceCounterFunctionStatus prop,
            /* [in] */ AgtSizeT hi,
            /* [retval][out] */ AgtValueT *val);
        
        void PerformanceCounterStatusReset( 
            /* [in] */ AgtPortHandleT portHandle);
        
        void PerformanceCounterStatusSnapshot( 
            /* [in] */ AgtPortHandleT portHandle);
        
        void TriggerOutSet( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIETriggerOut src,
            /* [in] */ AgtValueT val);
        
        void TriggerOutGet( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIETriggerOut src,
            /* [retval][out] */ AgtValueT *val);
        
        void TriggerOutStatusRead( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ AgtValueT prop,
            /* [retval][out] */ AgtValueT *val);
        
        void TriggerOutStatusClear( 
            /* [in] */ AgtPortHandleT portHandle);
        
        void DllpPropertySet( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIEDllp prop,
            /* [in] */ AgtValueT value);
        
        void DllpPropertyGet( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIEDllp prop,
            /* [retval][out] */ AgtValueT *value);
        
        void DllpControlSet( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIEDllpControl prop,
            /* [in] */ AgtValueT value);
        
        void DllpDataSend( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ AgtValueT dllpData);
        
        void DllpStatusGet( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIEDllpStatus status,
            /* [retval][out] */ AgtValueT *value);
        
        void DllpStatusClear( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIEDllpStatus status);
        
        void HostControllerVersionGet( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIEHostControllerVersion prop,
            /* [retval][out] */ AgtValueT *value);
        
        void SerialNumberGet( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [retval][out] */ UInt8 *pSerialNumber);
        
        void ScratchPadRegisterGet( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIEScratchPadRegister registerNum,
            /* [retval][out] */ AgtValueT *value);
        
        void ScratchPadRegisterSet( 
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIEScratchPadRegister registerNum,
            /* [in] */ AgtValueT value);
        
        
    protected:

        // Helper functions ///////////////////////////////////////////////////

        UInt32 getDecTypePropertyAddress(
            EPCIEDec dec,
            EPCIEDecProp prop);

        void MemWrite(
            AgtPortHandleT portHandle,
            UInt32 address,
            UInt32 numBytes,
            UInt32 size,
            UInt8* psaData);

        void MemRead(
            AgtPortHandleT portHandle,
            UInt32 address,
            UInt32 numBytes,
            UInt32 size,
            UInt32* pCount,
            UInt8* psaData);

        void GetBlockPropAddress(
            EPCIEHwChannelFunction channel,
            AgtValueT lineIndex,
            AgtValueT* address);

        void GetReqBehPropAddress(
            EPCIEHwChannelFunction channel,
            AgtValueT lineIndex,
            AgtValueT* address);

        void GetCompBehPropAddress(
            EPCIECompQueue queue,
            AgtValueT lineIndex,
            AgtValueT* address);

        bool ExerciserStatusReadFunction(
            AgtPortHandleT portHandle,
            EPCIEExerciserStatus status,
            AgtValueT* val);

        ///////////////////////////////////////////////////////////////////////

    public:

        void RegRead(
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ UInt32 address,
            /* [in] */ UInt8 size,
            /* [retval][out] */ UInt32& val);

        void RegRead(
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ UInt32 address,
            /* [in] */ UInt8 size,
            /* [retval][out] */ UInt32* val);

        void RegWrite(
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ UInt32 address,
            /* [in] */ UInt8 size,
            /* [in] */ UInt32 val);
            
        void RegRead(
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ UInt32 address,
            /* [in] */ UInt8 size,
            /* [in] */ bool bDoNotLock,
            /* [in] */ bool bDoNotUnlock,
            /* [retval][out] */ UInt32& val );

        void RegRead(
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ UInt32 address,
            /* [in] */ UInt8 size,
            /* [in] */ bool bDoNotLock,
            /* [in] */ bool bDoNotUnlock,
            /* [retval][out] */ UInt32* val );

        void RegWrite(
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ UInt32 address,
            /* [in] */ UInt8 size,
            /* [in] */ bool bDoNotLock,
            /* [in] */ bool bDoNotUnlock,
            /* [in] */ UInt32 val );
            
        void SetFunctionNumber(
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ UInt8 functionNum);
            
        void StartDebugLogging(
            /* [in] */ char* strFileName_p );
            
        void PerformanceCounterStatusReadAll(
            /* [in] */ AgtPortHandleT portHandle,
            /* [retval][out] */ AgtValueT *val );
            
        void PerformanceCounterStatusReadFunctionAll(
            /* [in] */ AgtPortHandleT portHandle,
            /* [in] */ EPCIEHwChannelFunction functionNum,
            /* [retval][out] */ AgtValueT *val );

    protected:

        CAgtPCIEControl* myController;
        CPCIEMemoryMgmt* myMemoryMgmt;
        CPCIEFpgaFramework* myFpgaFramework;
        CPCIESiMgmt* mSiMgmt;

        AgtValueT mCompletionAvailable;
        AgtValueT mSendImmediateSent;
        AgtValueT mBlockMemoryStopped;
        bool mReleaseFPGAAfterEachCall;
};

#endif